set terminal pdf color enhanced font "arial,22" size 6.0,4.0
set output "Zr_harm_ph_dispersion.pdf"
set encoding iso_8859_1
set xrange [0:3.4392]
set ylabel "Phonon frequency (meV)"
# set  ytics 5
unset xtics
set mytics 2
set format y "%.0f"
set label "{/Symbol G}" at -0.05, -21.3
set label "H" at 0.95, -21.3
set label "P" at 1.81, -21.3
set label "{/Symbol G}" at 2.68, -21.3
set label "N" at  3.38, -21.3

set arrow from 0.0,0.0 to 3.4392,0.0 lw 3 lc rgb "grey" nohead
set key at 3.0,24.93
set key maxrows 1
set key samplen 1.0 font ",20"
set label "Zr" at 0.8,1.5*4.136

set border lw 4

plot "Zr_harm_ph_dispersion.xmgr" u ($1):(($2*0.124)) t 'Harmonic - Monomorphous' w l lw 4 lc rgb "#7CCBA2"
