set terminal pdf color enhanced font "arial,22" size 6.0,4.0
set output "Zr_333_ph_dispersion.pdf"
set encoding iso_8859_1
set xrange [0:3.4392]
set yrange [0:25]
set ylabel "Phonon frequency (meV)"
# set  ytics 5
unset xtics
set mytics 2
set format y "%.0f"
set label "{/Symbol G}" at -0.05, -0.8
set label "H" at 0.95, -0.8
set label "P" at 1.81, -0.8
set label "{/Symbol G}" at 2.68, -0.8
set label "N" at  3.38, -0.8

set arrow from 0.0,0.0 to 3.4392,0.0 lw 3 lc rgb "grey" nohead
set key at 3.55,-1.25
set key maxrows 2
set key samplen 0.2 font ",20"
set label "Zr" at 0.8,1.5*4.136
set bmargin 2.6

set border lw 4

plot "Zr_04_ph_dispersion.xmgr" u ($1):(($2*0.124)) t 'iter 4 (2x2x2 supercell)' w l lw 4 lc rgb "black",\
     "Zr_333_dispersion_01.xmgr" u ($1):(($2*0.124)) t 'iter 1 (3x3x3 supercell)' w l lw 4 lc rgb "orange",\
     "Zr_333_dispersion_02.xmgr" u ($1):(($2*0.124)) t 'iter 2 (3x3x3 supercell)' w l lw 4 lc rgb "blue",\
     "Zr_333_dispersion_03.xmgr" u ($1):(($2*0.124)) t 'iter 3 (3x3x3 supercell)' w l lw 4 lc rgb "green"
